/*----------------------------------------------------------------------------------------------*
 * File Name: GridTableControl.h																*
 * Creation: Iris 05/17/08																		*
 * Purpose: 								 													*
 * Copyright (c) Originlab Corp.	2005, 2006, 2007, 2008, 2009, 2010							*
 * All Rights Reserved																			*
 * 																								*
 * Modification Log:																			*
 *	Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED		*
 *	Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB										*
 *	Jasmine 10/30/08 QA80-12425 SAVE_CONFIGURATION_NEED_COL_INDEX_AND_SHOW_ARRAY_HAVE_SAME_SIZE	*
 *	Kyle 11/05/2008 GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU										*
 *	Kyle 12/04/2008 ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU							*
 *	Kyle 12/08/2008 QA80-12425-P1 FILTER_THE_NOT_AVAILABLE_COLUMN_IN_SETGROUPCOLSHOWS			*
 *	Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL							*
 * Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH					*
 *----------------------------------------------------------------------------------------------*/

#ifndef _GRID_TABLE_CONTROL_H_
#define _GRID_TABLE_CONTROL_H_

/* CPY, should not need this hide show should just use true,false or 1,0
enum{
	COL_SHOW= 0,
    COL_HIDE
};
*/

class  GridTableControl: public GridListControl
{
public:
	//virtual 
	//void 	Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName)///Jasmine 05/18/10 ORG-2 CHANGE_DLG_TYPE_FOR_PROPERTY_PAGE
	void 	Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName)
	{
		GridListControl::Init(nID, dlg);			
	    
		SetAllowSelection(flexResizeColumns);
		SetSelection(flexSelectionFree);		
		SetExplorerBar(flexExNone);			
		SetEditable(flexEDKbdMouse);
		
		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		//m_strName = lpcszDlgName;		
		SetDlgName(lpcszDlgName);
		///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		m_nActiveGroup = -1; // no group		
	}
	
	void	SetColHeaderString(LPCSTR lpcszColHeader)
	{
		SetColHeader(lpcszColHeader);
		m_strColHeader = lpcszColHeader;
		
		/// Iris 5/23/2008 CLEANUP_SET_COLS_SHOW_FROM_REG
		/*
		vector<string> 	vsDefaultShows;
		for(int ii = 0; ii < m_strColHeader.GetNumTokens('|'); ii++)
		{
			vsDefaultShows.Add("0");
		}
		
		vector<string> 	vsColShows;
		getColsShowFromReg(-1, vsColShows);		
		m_strColShows.SetTokens(vsColShows, '|');
		*/
		setupColsShow();
		///end CLEANUP_SET_COLS_SHOW_FROM_REG
		setupColsWidth();	///Sophy 5/20/2008 SAVE_COLUMN_WIDTH_TO_REGISTER
	}
	
	void OnBeforeMouseDown(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel )
	{
		if(nButton == MK_RBUTTON && nShift == 0)
		{
			int    nx = XTwipsToPixels(X);
	        int    ny = YTwipsToPixels(Y);
	        ClientToScreen(nx, ny);
	        doShowHideColMenu(nx, ny);
	     }
	}

	
public:
	int		GetNumGroups() { return m_vsGroupColIndices.GetSize();}
	
	virtual string	GetClassName() { return "GridTableControl"; }
	
	void	SetGroup(int nGroup) { m_nActiveGroup = nGroup; }
	
	// show all if no group added
	// -1 also show all
	//nGroup > size will do nothing and return false
	bool	ShowGroup(int nGroup)
	{
		if( nGroup >= GetNumGroups() )
			return false;			
		m_nActiveGroup = nGroup;
		
		vector<byte>	vColHides;
		getColHides(vColHides);
		
		SetHiddenCols(vColHides);		
		
		return true;
	}
	
	bool	SetShow() { return ShowGroup(m_nActiveGroup); }
		
	int	AddGroup(const vector<int>& vnCols, const vector<uint>& vnDefaultShows = NULL)
	{
		// convert vnCols into string form "3|5|7" and add to our list m_vsGroupColIndices
		string 			strTemp;
		vector<string>	vsCols;
		convert_int_vector_to_string_vector(vnCols, vsCols);
		strTemp.SetTokens(vsCols, '|');
		m_vsGroupColIndices.Add(strTemp);		
		
		// load col show/hide state for this group from register, if fail, use vnDefaultShows, and then convert to "0|1|1" format and save to m_vsGroupShows
		int				nGroup = m_vsGroupColIndices.GetSize() - 1;
		/// Iris 5/23/2008 CLEANUP_SET_COLS_SHOW_FROM_REG
		//vector<string>	vsColShows;
		//getColsShowFromReg( nGroup, vsColShows, vnDefaultShows );
		//
		//strTemp.SetTokens(vsColShows, '|');
		//m_vsGroupColShows.Add(strTemp);
		setupColsShow(nGroup, vnDefaultShows);
		///end CLEANUP_SET_COLS_SHOW_FROM_REG
		
		return nGroup;
	}
	///Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	void DeleteGroup(int nGroup)
	{
		if( nGroup >= m_vsGroupColIndices.GetSize() )
			return;
		
		m_vsGroupColIndices.RemoveAt(nGroup);
		m_vsGroupColShows.RemoveAt(nGroup);
	}
	
	bool SetGroupColShows(int nGroup, const vector<int>& vnCols, const vector<byte>& vbShows)
	{		
		if(m_vsGroupColIndices.GetSize() <= nGroup)
			return false;

		vector<string>	vsCols;
		convert_int_vector_to_string_vector(vnCols, vsCols);
		
		string 	strColIndices;
		strColIndices.SetTokens(vsCols, '|');
		m_vsGroupColIndices[nGroup] = strColIndices;		
				
		///Kyle 12/08/2008 QA80-12425-P1 FILTER_THE_NOT_AVAILABLE_COLUMN_IN_SETGROUPCOLSHOWS
		//setGroupColShows(nGroup, vbShows);		
		vector<int> vnColDisable;
		vector<byte> vbColShows;
		vector<uint> vecIndices;
		GetColDisable(vnColDisable);
		vbColShows = vbShows;
		for(int ii=0; ii<vnColDisable.GetSize(); ii++)
		{
			if(vnCols.Find(vecIndices, vnColDisable[ii])>0)
			{
				ASSERT(1 == vecIndices.GetSize());
				vbColShows[vecIndices[0]] = false;
			}
		}
		setGroupColShows(nGroup, vbColShows);
		///End FILTER_THE_NOT_AVAILABLE_COLUMN_IN_SETGROUPCOLSHOWS
		
		return true;
	}
	int GetGroupColShows(int nGroup, vector<int>& vnCols, vector<byte>& vbShows)
	{
		if( !getGroupColIndices(nGroup, vnCols) )
			return -1;
		
		getGroupColHides(nGroup, vbShows);
		vbShows = !vbShows;
		
		ASSERT( vnCols.GetSize() == vbShows.GetSize() );
		return vnCols.GetSize();
	}
	///End CUSTOMIZATION_PARAMETER_TAB
	
	///Sophy 5/20/2008 GRID_SUPPORT_BUTTON_TYPE_COL
	///Kyle 09/12/08 SET_FUNCTION_ONBUTTONCLICK_AS_VIRTUAL
	//void	OnButtonClick(Control cntrl, int nRow, int nCol)
	virtual void	OnButtonClick(Control cntrl, int nRow, int nCol)
	///End SET_FUNCTION_ONBUTTONCLICK_AS_VIRTUAL
	{
		if( nCol < 0 || nCol >= m_vsComboLists.GetSize() )
			return;
		
		vector<string>	vsTemp;
		string			strOld;
		int				nCount;
		int				nIndex;
		
		nCount = m_vsComboLists[nCol].GetTokens(vsTemp, '|');
		strOld = GetCell( flexcpText, nRow, nCol );
		nIndex = vsTemp.Find( strOld );
		if( nIndex < 0 )
			nIndex = 0;
		
		nIndex = (nIndex + 1 ) % nCount;
		SetCell(vsTemp[nIndex], flexcpText, nRow, nCol);
		
		return;
	}
	
	bool	SetButtonType( int nCol, LPCSTR lpcszList )
	{
		//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
		//m_flx.ColComboList( nCol ) = "...";
		//------

		if( nCol >= m_vsComboLists.GetSize() )
			m_vsComboLists.SetSize( nCol + 1);
		
		m_vsComboLists[nCol] = lpcszList;
		
		return true;
	}
	///end GRID_SUPPORT_BUTTON_TYPE_COL
	
	BOOL 	OnDestroy()
	{
		saveHideCols();
		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		//saveColsWidthToReg();
		SaveColsWidthToReg();
		///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		return TRUE;
	}

//------ Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
protected:
	///Kyle 11/05/2008 GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	//virtual	void	GetColMenuDisableItems(vector<bool>& vbItemsDisable)
	virtual	void	GetColMenuDisableItems(vector<int> vnGroupIndices, vector<bool>& vbItemsDisable)
	///Edn GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	{
		vbItemsDisable.SetSize(getNumCols());
		vbItemsDisable = false;
		
		///Kyle 11/05/2008 GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
		vector<int> vnColDisable;
		GetColDisable(vnColDisable);
		for(int ii=0; ii<vnColDisable.GetSize(); ii++)
		{
			vector<uint> vIndex;
			if(vnGroupIndices.Find(vIndex, vnColDisable[ii])>0)
			{
				vbItemsDisable[ vIndex[0] ] = true;
			}
		}
		///End GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	}
	///Kyle 11/05/2008 GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	virtual void GetColDisable(vector<int>& vnColDisable)
	{
		vnColDisable.SetSize(0);
	}
	///End GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
//------ End SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED

	///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	/*string			GetDlgNameForRegistry()
	{
		return m_strName + "\\" + GetClassName();
	}*/
	///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
  	
private:
	// get col show/hide state for all cols
	void	getColHides(vector<byte>& vColHides)
	{
        vector<int> 	vnGroupIndices;
        getGroupColIndices(m_nActiveGroup, vnGroupIndices);
        
		vector<byte>	vnGroupColHides;
		getGroupColHides(m_nActiveGroup, vnGroupColHides);
		
		vColHides.SetSize(GetNumCols());
		vColHides = 1;
		for( int ii = 0; ii < vnGroupIndices.GetSize(); ii++)
		{
			vColHides[vnGroupIndices[ii]] = vnGroupColHides[ii];
		}
	}
	// retur true means successfully toggle show column
	virtual bool 	toggleShowCol(int nCol, int nNumShowCols = -1)
	{   
		// nNumShowCols default value -1 indicates that all the cloumns can hide, otherwise keep last column showing
		bool	bKeepLastColShow = nNumShowCols < 0? false : true;
		
	    if( bKeepLastColShow && 1 == nNumShowCols && !IsColHidden(nCol))
	    {
	    	return false;
	    }
	    else 
	    {
	    	HideCol(nCol, IsColHidden(nCol)? false:true);
	    	return true;
	    }
  	}
	bool 	getGroupColHeaders(int nGroup, vector<string> &vsGroupColHeaders)
	{			
		vector<string> 	vsColHeaders;
		m_strColHeader.GetTokens(vsColHeaders,'|');
		
		if( -1 == nGroup )
		{
			vsGroupColHeaders = vsColHeaders;
			return true;
		}
		
		vector<int> 	vnIndices;
		if( !getGroupColIndices(nGroup, vnIndices) )
			return false;		
		
		for(int ii = 0;ii < vnIndices.GetSize(); ii++)
			vsGroupColHeaders.Add(vsColHeaders[vnIndices[ii]]);
		return true;
	}
	
	bool	getGroupColIndices(int nGroup, vector<int> &vn)
	{		
		if(nGroup >= m_vsGroupColIndices.GetSize())
			return false;
		
		if( -1 == nGroup )
		{
			vn.Data(0, GetNumCols()-1, 1);
			return true;
		}
		
		vector<string> 		vsCols;
		m_vsGroupColIndices[nGroup].GetTokens(vsCols,'|');
		convert_string_vector_to_int_vector(vsCols, vn);
		//need to assert vn has only >= values here
		return true;
	}
	
	bool	getGroupColHides(int nGroup, vector<byte>& vHides)
	{
		if(nGroup >= m_vsGroupColShows.GetSize())
			return false;
		
		string				strColShows;
		if( -1 == nGroup )
		{
			strColShows = m_strColShows;
		}
		else
		{
			strColShows = m_vsGroupColShows[nGroup];
		}
		
		vector<string> 		vsShows;
		vector<byte>		vShows;
		strColShows.GetTokens(vsShows, '|');
		convert_string_vector_to_byte_vector(vsShows, vShows);		
		
		vHides = !vShows;
		return true;		
	}
	
	bool	setGroupColShows(int nGroup, vector<byte> &vbShows)
	{
		if(nGroup >= m_vsGroupColShows.GetSize())
			return false;
		
		vector<string> 		vsCols;
		convert_byte_vector_to_string_vector(vbShows, vsCols);
		
		string				str;
		str.SetTokens(vsCols,'|');
		
		if( -1 == nGroup ) // -1 for all columns
			m_strColShows = str;
		else
			m_vsGroupColShows[nGroup] = str;
		
		return true;		
	}
	
	void 	doShowHideColMenu(int nx, int ny )
	{
		int nRow, nCol, nFirstRowIndex = 0;
		
		GetMouseCell(nRow,nCol);		
	    if(nRow == nFirstRowIndex)
		{		        
	        vector<int> 	vnGroupIndices;
	        vector<string> 	vsGroupColHeaders;
	        if( !getGroupColIndices(m_nActiveGroup, vnGroupIndices) )
	        {
	        	string str = "Fail to get vnGroupIndices in doShowHideColMenu for group " + m_nActiveGroup;
	        	error_report(str);
	        	return;
	        }
	        if ( !getGroupColHeaders(m_nActiveGroup, vsGroupColHeaders) )
	        {
	        	string str = "Fail to get vsGroupColHeaders in doShowHideColMenu for group " + m_nActiveGroup;
	        	error_report(str);
	        	return;
	        }
	        	
	        
	        // get curent col show/hide state by group from table
			vector<byte> 	vbGroupShows;
	        vbGroupShows.SetSize(vnGroupIndices.GetSize() );	   
	        for( int ii = 0; ii < vnGroupIndices.GetSize(); ii++ )
	        {
	        	vbGroupShows[ii] = !IsColHidden(vnGroupIndices[ii]);
	        }
	        
	        int        	nNumShowCols = 0;
	        vbGroupShows.Sum(nNumShowCols);
	        //------ Folger 10/08/08 SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
	  		//CheckMenu 	MyMenu(vbGroupShows, vsGroupColHeaders);
	  		vector<bool>		vbItemsDisable;
	  		///Kyle 11/05/2008 GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	  		//GetColMenuDisableItems(vbItemsDisable);
	  		GetColMenuDisableItems(vnGroupIndices, vbItemsDisable);
	  		///End GET_DISABLED_ITEMS_IN_SHORT_CUT_MENU
	  		///Kyle 12/04/2008 ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
	  		vsGroupColHeaders.Add("");		//separator
	  		vbGroupShows.Add(false);
	  		vbItemsDisable.Add(false);

	  		vsGroupColHeaders.Add(_L("Show All Columns"));
	  		vbGroupShows.Add(false);
	  		vbItemsDisable.Add(false);
	  		///End ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
	  		CheckMenu 	MyMenu(vbGroupShows, vsGroupColHeaders, vbItemsDisable);
	  		//------ End SHOULD_NOT_ALLOW_SHOW_SHARE_CLOUMN_WHEN_PARAM_SHARING_IS_NOT_ALLOWED
		    int 		nChoice = MyMenu.DoTrackPopup(nx, ny, GetDlgSafeHwnd() );
		    if(nChoice >= 0)
		    {
		    	///Kyle 12/04/2008 ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
		    	//bool	bRet = toggleShowCol(vnGroupIndices[nChoice], nNumShowCols);
		    	vbGroupShows.SetSize(vnGroupIndices.GetSize());			// remove the last two items (separator and "Show All Columns")
		    	bool bRet = true;
		    	if(nChoice < vnGroupIndices.GetSize())
		    	{
		    		bRet = toggleShowCol(vnGroupIndices[nChoice], nNumShowCols);
		    	}
		    	else
		    	{
		    		for(ii = vnGroupIndices.GetSize()-1; ii>=0; ii--)
		    		{
		    			if(vbItemsDisable[ii])
		    				continue;
		    			HideCol(vnGroupIndices[ii], false);
		    		}
		    	}
		    	///End ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
		    	if(bRet)
		    	{		    	
		    		///Kyle 12/04/2008 ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
		    		//vbGroupShows[nChoice] = !IsColHidden(vnGroupIndices[nChoice]);
		    		if(nChoice < vnGroupIndices.GetSize())
		    		{
		    			vbGroupShows[nChoice] = !IsColHidden(vnGroupIndices[nChoice]);
		    		}
		    		else
		    		{
			    		for(ii = vnGroupIndices.GetSize()-1; ii>=0; ii--)
			    		{
			    			if(vbItemsDisable[ii])
			    				continue;
			    			vbGroupShows[ii] = !IsColHidden(vnGroupIndices[ii]);
			    		}
		    		}
		    		///End ADD_ITEM_SHOW_ALL_COLUMNS_FOR_PARAMETERS_CHECK_MENU
		    		// save group col show/hide state after toggle col
		    		//vector<uint>	vnGroupShow;
		    		//vnGroupShow = vbGroupShows;
		    		setGroupColShows(m_nActiveGroup, vbGroupShows);
		    	}
		    }
	    }
	}
	
	/// Iris 5/23/2008 CLEANUP_SET_COLS_SHOW_FROM_REG
	void	setupColsShow(int nGroup = -1, const vector<uint>& vnDefaultShows = NULL)
	{
		vector<uint> vnDefaultShowsTemp;
		if( vnDefaultShows )
		{
			vnDefaultShowsTemp = vnDefaultShows;
		}
		else
		{
			getGroupDefaultShows(vnDefaultShowsTemp, nGroup);
		}
		
		vector<string>	vsColShows;
		//---Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
		if( IsReady() )
			convert_uint_vector_to_string_vector(vnDefaultShowsTemp, vsColShows);
		else
			getColsShowFromReg( nGroup, vsColShows, vnDefaultShowsTemp );
		//---end
		
		if( nGroup < 0 )
		{
			m_strColShows.SetTokens(vsColShows, '|');			
		}
		else
		{
			string			str;
			str.SetTokens(vsColShows, '|');
			
			if( nGroup >= m_vsGroupColShows.GetSize() )
				m_vsGroupColShows.SetSize( nGroup + 1 );
			m_vsGroupColShows[nGroup] = str;
		}
	}
	///end CLEANUP_SET_COLS_SHOW_FROM_REG
	//---Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	virtual int getGroupDefaultShows(vector<uint>& vnDefaultShows, int nGroup = -1)
	{
		vnDefaultShows.SetSize(getGroupNumCols(nGroup));
		vnDefaultShows = 1;
		return vnDefaultShows.GetSize();
	}
	//---end
	
	int		getGroupNumCols(int nGroup)
	{
		if( nGroup < 0)
			return m_strColHeader.GetNumTokens('|');
		
		return m_vsGroupColIndices[nGroup].GetNumTokens('|');
	}
	
	int		getNumCols()
	{
		if( 0 == GetNumGroups() || -1 == m_nActiveGroup )
			return GetNumCols();
		
		return getGroupNumCols(m_nActiveGroup);
	}
	// get col show/hide state from register
	bool	getColsShowFromReg(int nGroup, vector<string>& vsColShows, const vector<uint>& vnDefaultShows = NULL)
	{
		string		strDlgName = GetDlgNameForRegistry();
		///Sophy 5/20/2008 SAVE_COLUMN_WIDTH_TO_REGISTER
		//string		strKeyName = getRegKeyName( nGroup);
		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		//string		strKeyName = getRegKeyName( "ColHides", nGroup);
		string		strKeyName = GetRegKeyName( "ColHides", nGroup);
		///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		///end SAVE_COLUMN_WIDTH_TO_REGISTER
			
				
		vector<uint>	vnColShows;
		vector<byte> 	vColHides;
		if( load_default_checkboxes(strDlgName, vColHides, strKeyName) ) 
		{
			//---Jasmine 10/30/08 QA80-12425 SAVE_CONFIGURATION_NEED_COL_INDEX_AND_SHOW_ARRAY_HAVE_SAME_SIZE
			int nCols = getGroupNumCols(nGroup);
			ASSERT(nCols > 0);
			vColHides.SetSize(nCols);
			//---
			vnColShows = !vColHides;
		}
		else
		{
			vector<uint>	vnDefaultShowsTemp(getNumCols());
			vnDefaultShowsTemp = 1;
			if( NULL != vnDefaultShows)
				vnDefaultShowsTemp = vnDefaultShows;
			
			vnColShows = vnDefaultShowsTemp;			
		}
		
		convert_uint_vector_to_string_vector(vnColShows, vsColShows);
		return false;	
	}	
	
	// save col show/hide state to register by group
 	void	saveHideCols()
	{		
		if( 0 == GetNumGroups() ) //no group
		{
			groupSaveHideCols(-1);
			return;
		}
		
		for(int nGroup = 0; nGroup < GetNumGroups(); nGroup++)
		{			
			groupSaveHideCols(nGroup);
		}
	} 

	void  	groupSaveHideCols(int nGroup)
	{
		vector<byte>	vHides;
		if( getGroupColHides(nGroup, vHides) )
		{		
			string		strDlgName = GetDlgNameForRegistry();
			///Sophy 5/20/2008 SAVE_COLUMN_WIDTH_TO_REGISTER
			//string		strKeyName = getRegKeyName( nGroup);
			///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
			//string		strKeyName = getRegKeyName( "ColHides", nGroup);
			string		strKeyName = GetRegKeyName( "ColHides", nGroup);
			///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
			///end SAVE_COLUMN_WIDTH_TO_REGISTER
			save_default_checkboxes(strDlgName, vHides, strKeyName);
		}		
	}
	///Sophy 5/20/2008 SAVE_COLUMN_WIDTH_TO_REGISTER
	/*
	string	getRegKeyName(int nGroup)
	{
		string		strKeyName = "ColHides";
		if( nGroup >= 0 )
		{
			strKeyName += "_Group" + (nGroup+1);
		}	
		return strKeyName;
	}
	*/
	///Kenny 04/27/2009 FUNC_LOAD_SAVE_COL_WIDTH_IN_GRIDTABLECONTROL_MOVE_TO_GRIDLISTCONTROL
	/*string	getRegKeyName( LPCSTR lpcszBasic, int nGroup = -1 )
	{
		string	strKeyName( lpcszBasic );
		if( nGroup >= 0 )
		{
			strKeyName += "_Group" + ( nGroup + 1 );
		}
		return	strKeyName;
	}
	
	bool	loadColsWidthFromReg( vector<uint>& vnColWidth)
	{
		string			strDlgName = GetDlgNameForRegistry();
		string			strKeyName = getRegKeyName( "ColWidth");
		string			strColsWidth;
		vector<string>	vsColWidth;
		bool			bRet;
		
		
		if( bRet = dlg_load_registry( strDlgName, strKeyName, strColsWidth) )
		{
			strColsWidth.GetTokens( vsColWidth, '|');
			convert_string_vector_to_uint_vector( vsColWidth, vnColWidth );
		}

		return bRet;
	}
	
	bool	saveColsWidthToReg()
	{
		string			strDlgName = GetDlgNameForRegistry();
		string			strKeyName = getRegKeyName( "ColWidth" );
		vector<uint>	vnColsWidth;
		vector<string>	vsColsWidth;
		string			strColsWidth;
		
		int nCols = GetNumCols();
		if( 0 == nCols )
			return false;
		
		vnColsWidth.SetSize( nCols );
		for( int ii = 0; ii < nCols; ii++)
			vnColsWidth[ii] = GetColWidth( ii );
		
		convert_uint_vector_to_string_vector( vnColsWidth, vsColsWidth);
		strColsWidth.SetTokens( vsColsWidth, '|' );
		dlg_save_to_registry( strDlgName, strKeyName, strColsWidth );
		
		return true;
	}
	
	void	setColsWidth( const vector<uint>& vnColsWidth)
	{
		int	nCols = GetNumCols();
		ASSERT( vnColsWidth.GetSize() == nCols );
		
		for( int ii = 0; ii < nCols; ii++)
			SetColWidth( ii, vnColsWidth[ii]);
		
		return;
	}*/
	///End FUNC_LOAD_SAVE_COL_WIDTH_IN_GRIDTABLECONTROL_MOVE_TO_GRIDLISTCONTROL
	
	void	setupColsWidth()
	{
		vector<uint> vnColsWidth;
		
		///Kenny 04/27/2009 QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
		//if( loadColsWidthFromReg( vnColsWidth ) )
			//setColsWidth( vnColsWidth );
		if( LoadColsWidthFromReg( vnColsWidth ) )
			SetColsWidth( vnColsWidth );
		///End QA80-13519-P3 COL_BROWSER_DLG_SHOULD_REMEMBER_COLUMN_WIDTH
	}
	///end SAVE_COLUMN_WIDTH_TO_REGISTER

	
private:
	// each group is represented by a list of column indices, and we pack them like c1|c2|c3
	vector<string>		m_vsGroupColIndices; // to save col index by group
	vector<string>		m_vsGroupColShows; // to save col show/hide (1/0) states accordint to m_vsGroupColIndices
	vector<string>		m_vsComboLists;		///Sophy 5/20/2008 GRID_SUPPORT_BUTTON_TYPE_COL	
	int                 m_nActiveGroup;
	string				m_strColShows;		// col show/hide state string for no group	
	
	
	//string				m_strName;//CPY 5/11/08	///Kenny 04/27/2009 ADD_FUNC_GET_SET_DLG_NAME_TO_GRID_LIST_CONTROL
protected:
	///Jasminie 01/29/10 CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
	string				m_strColHeader;		// all col header
	///End CONFIGURE_SHOW_HIDE_SETTING_BY_MENU
};



#endif //_GRID_TABLE_CONTROL_H_
